/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.event.drop;

import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.entity.BladeItemEntity;
import mods.flammpfeil.slashblade.event.drop.EntityDropEntry;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.registry.slashblade.SlashBladeDefinition;
import net.minecraft.core.Registry;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class EntityDropEvent {
    @SubscribeEvent
    public static void dropBlade(LivingDropsEvent event) {
        LivingEntity entity = event.getEntity();
        Registry<SlashBladeDefinition> bladeRegistry = SlashBlade.getSlashBladeDefinitionRegistry(entity.m_9236_());
        entity.m_9236_().m_9598_().m_175515_(EntityDropEntry.REGISTRY_KEY).forEach(entry -> {
            if (!ForgeRegistries.ENTITY_TYPES.containsKey(entry.getEntityType())) {
                return;
            }
            if (!bladeRegistry.m_7804_(entry.getBladeName())) {
                return;
            }
            if (!(event.getSource().m_7639_() instanceof LivingEntity)) {
                return;
            }
            LivingEntity attacker = (LivingEntity)event.getSource().m_7639_();
            if (entry.isRequestSlashBladeKill() && !(attacker.m_21205_().m_41720_() instanceof ItemSlashBlade)) {
                return;
            }
            float resultRate = Math.min(1.0f, entry.getDropRate() + (float)event.getLootingLevel() * 0.1f);
            if (entry.isDropFixedPoint()) {
                EntityDropEvent.dropBlade(entity, (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entry.getEntityType()), ((SlashBladeDefinition)bladeRegistry.m_7745_(entry.getBladeName())).getBlade(), resultRate, entry.getDropPoint().f_82479_, entry.getDropPoint().f_82480_, entry.getDropPoint().f_82481_);
            } else {
                EntityDropEvent.dropBlade(entity, (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entry.getEntityType()), ((SlashBladeDefinition)bladeRegistry.m_7745_(entry.getBladeName())).getBlade(), resultRate, entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            }
        });
    }

    public static void dropBlade(LivingEntity entity, EntityType<?> type, ItemStack blade, float percent, double x, double y, double z) {
        if (entity.m_6095_().equals(type)) {
            RandomSource rand = entity.m_9236_().m_213780_();
            if (rand.m_188501_() > percent) {
                return;
            }
            ItemEntity itementity = new ItemEntity(entity.m_9236_(), x, y, z, blade);
            BladeItemEntity e = new BladeItemEntity(SlashBlade.RegistryEvents.BladeItem, entity.m_9236_());
            e.m_20361_((Entity)itementity);
            e.init();
            e.m_5997_(0.0, 0.4, 0.0);
            e.m_32010_(40);
            e.m_146915_(true);
            e.m_20301_(-1);
            e.m_32052_(entity.m_20148_());
            entity.m_9236_().m_7967_((Entity)e);
        }
    }
}

